IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_RC_CONVENIO_BLOQUEIA]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_RC_CONVENIO_BLOQUEIA]
GO


--EXEC P_RC_CONVENIO_BLOQUEIA
--Procedure para atualizar a  as venda do convênio com a data de fechamento ou agendamento do convênio
CREATE PROCEDURE [dbo].[P_RC_CONVENIO_BLOQUEIA] (@IN_CD_EMP		INT = 1) AS

--Criando a tabela temporaria
CREATE TABLE #RS_BLOQ_CONVENIO (	
					CD_EMP int,
					CD_CLI int,
					CD_CONV INT)
					
--Criando a tabela temporaria
CREATE TABLE #RS_LIB_CONVENIO (	
					CD_EMP int,
					CD_CLI int,
					CD_CONV INT)					


--Inserindo os dados dos clientes na tabela temporaria
INSERT INTO #RS_BLOQ_CONVENIO
SELECT distinct BLOQ.CD_EMP,BLOQ.CD_CLI ,BLOQ.CD_CONV FROM 
(SELECT distinct
	1 AS CD_EMP,
	CD_CLI,
	CD_CONV
FROM 
	V_RC_DEB_RC_CLI_CONV_BLOQUEIO
WHERE 
	DT_LIMITE < DT_ATUAL) BLOQ INNER JOIN RC_CLI_CONV CONV ON
	BLOQ.CD_EMP=CONV.CD_EMP AND
	BLOQ.CD_CLI=CONV.CD_CLI 
WHERE 
	CONV.STS_CRED=0
	

INSERT INTO #RS_LIB_CONVENIO
SELECT 
    LIB.CD_EMP,
    LIB.CD_CLI,
	CONV.CD_CONV 
 FROM 
	(SELECT DISTINCT
		 1 AS CD_EMP,
		 CD_CLI,
		 CD_CONV
	FROM 
		RC_CLI_CONV CONV
	WHERE CD_CONV  NOT IN (SELECT DISTINCT CD_CONV FROM V_RC_DEB_RC_CLI_CONV_BLOQUEIO BLOQ WHERE BLOQ.DT_LIMITE<BLOQ.DT_ATUAL)) LIB INNER JOIN RC_CLI_CONV CONV ON
		LIB.CD_EMP=CONV.CD_EMP AND
		LIB.CD_CONV=CONV.CD_CONV 
	WHERE
		CONV.STS_CRED=1
		AND CONV.CONV_HABILITADO=0



--Criando variavel que vai receber o codigo do cliente
DECLARE	@CD_EMP INT
DECLARE	@CD_CLI INT
DECLARE @CD_CONV INT

DECLARE	@CD_EMP_LIB INT
DECLARE	@CD_CLI_LIB INT
DECLARE @CD_CONV_LIB INT


--Criando o cursos de alteração para que possamos alterar cliente a cliente
--assim não iremos bloquear as paginas do banco de dados
--somente o registro que esta sendo alterado, assim o usuário final não vai perceber
--forma mais efeciente de atualizar os clientes sem bloquear os usuários finais
SET NOCOUNT ON
DECLARE Bloqueio CURSOR FAST_FORWARD FOR SELECT CD_EMP,CD_CLI,CD_CONV FROM #RS_BLOQ_CONVENIO
OPEN Bloqueio
FETCH NEXT FROM Bloqueio INTO @CD_EMP,@CD_CLI,@CD_CONV
WHILE @@FETCH_STATUS=0
	Begin
		UPDATE 
				t
		SET 
			T.STS_CRED = 1
		FROM 
			RC_CLI_CONV  t
		WHERE
			t.CD_EMP = @CD_EMP
			AND t.CD_CLI = @CD_CLI
			AND T.CD_CONV=@CD_CONV
		FETCH NEXT FROM Bloqueio INTO @CD_EMP,@CD_CLI,@CD_CONV
	End

PRINT 'Concluído Bloqueio.'

--Criando o cursos de alteração para que possamos alterar cliente a cliente
--assim não iremos bloquear as paginas do banco de dados
--somente o registro que esta sendo alterado, assim o usuário final não vai perceber
--forma mais efeciente de atualizar os clientes sem bloquear os usuários finais
SET NOCOUNT ON
DECLARE Libera CURSOR FAST_FORWARD FOR SELECT CD_EMP,CD_CLI,CD_CONV FROM #RS_LIB_CONVENIO
OPEN Libera
FETCH NEXT FROM Libera INTO @CD_EMP_LIB,@CD_CLI_LIB,@CD_CONV_LIB
WHILE @@FETCH_STATUS=0
	Begin
		UPDATE 
				t
		SET 
			t.STS_CRED = 0
		FROM 
			RC_CLI_CONV  t
		WHERE
			t.CD_EMP = @CD_EMP_LIB
			AND t.CD_CLI = @CD_CLI_LIB
			AND T.CD_CONV=@CD_CONV
		FETCH NEXT FROM Libera INTO @CD_EMP_LIB,@CD_CLI_LIB,@CD_CONV_LIB
	End

PRINT 'Concluído Liberação.'


--Fechando cursos
CLOSE Bloqueio;
--Desalocando cursos da memoria
DEALLOCATE Bloqueio;
--Apagando a tabela temporaria
DROP TABLE #RS_BLOQ_CONVENIO;


--Fechando cursos
CLOSE Libera;
--Desalocando cursos da memoria
DEALLOCATE Libera;
--Apagando a tabela temporaria
DROP TABLE #RS_LIB_CONVENIO;



GO


